const isAuthenticated = (req, res, next) => {
  if (req.session && req.session.user) {
    return next();
  }
  return res.status(401).json({
    message: "Unauthorized: You must be logged in."
  });
};
const isAdmin = (req, res, next) => {
  if (req.session.user && req.session.user.role === 'admin') {
    return next();
  }
  return res.status(403).json({
    message: "Forbidden: Administrator access required."
  });
};
const isAdminPage = (req, res, next) => {
  if (req.session.user && req.session.user.role === 'admin') {
    return next();
  }
  return res.redirect('/login');
};
const canDispatch = (req, res, next) => {
  const user = req.session.user;
  if (user && (user.role === 'admin' || user.permissions && user.permissions.includes('dispatch'))) {
    return next();
  }
  return res.status(403).json({
    message: "Forbidden: You do not have dispatch permissions."
  });
};
const canUpdateDispatch = (req, res, next) => {
  const user = req.session.user;
  if (user && (user.role === 'admin' || user.permissions && user.permissions.includes('update_dispatch'))) {
    return next();
  }
  return res.status(403).json({
    message: "Forbidden: You do not have permission to update dispatch status."
  });
};
const canUpdateDispatchPage = (req, res, next) => {
  const user = req.session.user;
  if (user && (user.role === 'admin' || user.permissions && user.permissions.includes('update_dispatch'))) {
    return next();
  }
  return res.redirect('/dashboard');
};
const isManagerOrAdminPage = (req, res, next) => {
  const user = req.session.user;
  if (user && (user.role === 'admin' || user.role === 'manager')) {
    return next();
  }
  return res.redirect('/dashboard');
};
module.exports = {
  isAuthenticated,
  isAdmin,
  isAdminPage,
  canDispatch,
  canUpdateDispatch,
  canUpdateDispatchPage,
  isManagerOrAdminPage
};